﻿var BreadCrunmsValue = "";

var setting = 
{
	data:{
		simpleData:{
			enable: true,
			idKey: "id",
			pIdKey: "pId",
			rootPId: 0
		}
	},
	callback:{
		onClick: changeBreadCrumbs
	},
	view:{
		showLine: true,
		showIcon: false
	}
		
};

function getNodeLevel(tree, treeId, treeNode, index)
{
	var value;
	var parentNode;
	var parentName = "";
	var parentPid = "";
	var grandNode;
	var grandName = "";
	var grandPid = "";
	var oldestNode;
	var oldestName = "";
	if(index == 1)
	{
		value = treeNode.name;
	}
	else if(index == 2)
	{
		parentNode = tree.getNodeByParam("id", treeNode.pId, null);
		parentName = parentNode.name;
		value = (parentName + " > " + treeNode.name);
	}
	else if(index == 3)
	{
		parentNode = tree.getNodeByParam("id", treeNode.pId, null);
		parentName = parentNode.name;
		parentPid = parentNode.pId;
		grandNode = tree.getNodeByParam("id", parentPid, null);
		grandName = grandNode.name;
		if((treeId == "Monitor") || (treeId == "Cards"))
		{
			value = (grandName + " > " + parentName + " > " + treeNode.name);
		}
		else
		{
			value = (grandName + " > " + parentName + " > " + treeNode.name);
		}
	}
	else if(index == 4)
	{
		parentNode = tree.getNodeByParam("id", treeNode.pId, null);
		parentName = parentNode.name;
		grandPid = parentNode.pId;
		grandNode = tree.getNodeByParam("id", grandPid, null);
		grandName = grandNode.name;
		grandPid = grandNode.pId;
		oldestNode = tree.getNodeByParam("id", grandPid, null);
		oldestName = oldestNode.name;
		value = (oldestName + " > " + grandName + " > " + parentName + " > " + treeNode.name);
	}
	return value;
}

function changeBreadCrumbs(event, treeId, treeNode)
{
	var language = document.getElementById("language").value;
	var treeObj = $.fn.zTree.getZTreeObj(treeId);
	var levelValue = "";
	if(language == 0)
	{
		BreadCrunmsValue = (" > " + treeId);
	}
	else
	{
		BreadCrunmsValue = (" > " + getTreeIdCh(treeId));
	}
	if(treeId == "Scramb")
	{
		var idIndex = parseInt(treeNode.id.toString().charAt(0));
		var pId = treeNode.pId;
		if(((idIndex < 3) && (pId == 0)) || ((idIndex == 3) && (treeNode.id.toString().length < 3)))
		{
			return;
		}
	}
	if(treeNode.id.toString().length <= 3)
	{
		if((treeNode.id.toString().length == 3) && (treeId == "Scramb") && (treeNode.pId == 1))
		{
			levelValue = getNodeLevel(treeObj, treeId, treeNode, 2);
		}
		else
		{
			levelValue = getNodeLevel(treeObj, treeId, treeNode, treeNode.id.toString().length);
		}
	}
	else
	{
		if((treeId == "Monitor") || (treeId == "Cards"))
		{
			levelValue = getNodeLevel(treeObj, treeId, treeNode, 4);
		}
		else
		{
			levelValue = getNodeLevel(treeObj, treeId, treeNode, 3);
		}
	}
	BreadCrunmsValue += (" > " + levelValue);
	document.getElementById("breadCrumbsText").innerHTML = BreadCrunmsValue;
};

function CreateMonitor()
{
	var Monitor = $.fn.zTree.init($("#Monitor"), setting, zNodesMonitor);
	AddTree("Monitor", Monitor);
	Monitor.selectNode(Monitor.getNodeByParam("id", 0));
}

function CreateAlarms()
{
	var Alarms = $.fn.zTree.init($("#Alarms"), setting, zNodesAlarms);
	AddTree("Alarms", Alarms);
	Alarms.selectNode(Alarms.getNodeByParam("id", 1));
}

function CreateCards()
{
	var Cards = $.fn.zTree.init($("#Cards"), setting, zNodesCards);
	AddTree("Cards", Cards);
	Cards.selectNode(Cards.getNodeByParam("id", 1));
}

function CreateMaps()
{
	var Maps = $.fn.zTree.init($("#Maps"), setting, zNodesMaps);
	AddTree("Maps", Maps);
	Maps.selectNode(Maps.getNodeByParam("id", 1));
}

function CreateScramb()
{
	var Scramb = $.fn.zTree.init($("#Scramb"), setting, zNodesScramb);
	AddTree("Scramb", Scramb);
	Scramb.selectNode(Scramb.getNodeByParam("id", 117));
}

function CreateSystem()
{
	var System = $.fn.zTree.init($("#System"), setting, zNodesSystem);
	AddTree("System", System);
	System.selectNode(System.getNodeByParam("id", 1));
}

function CreateMux()
{
	var Mux = $.fn.zTree.init($("#Mux"), setting, zNodesMux);
	AddTree("Mux", Mux);
	if(Mux.getNodeByParam("level", 2) != null)
	{
		Mux.selectNode(Mux.getNodeByParam("level", 2));
	}
}
/*************************************************
Function: 		psiTableJump
Description: 	面包屑菜单的链接跳转函数
Input: 			
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function psiTableJump()
{
	var id;
	self.frames[0].location.replace(psiUrl);
	$("#dynamicText").remove();
}
